@extends('installer.layout')

@section('content')
    <h2 class="text-2xl font-bold text-gray-900 mb-6">Database & Admin Setup</h2>
    
    <form action="{{ route('installer.install') }}" method="POST" class="space-y-6">
        @csrf
        
        <!-- Database Section -->
        <div>
            <h3 class="text-lg font-medium text-gray-900 border-b pb-2 mb-4">Database Connection</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Database Host</label>
                    <input type="text" name="db_host" value="127.0.0.1" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 p-2 border" required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Database Port</label>
                    <input type="text" name="db_port" value="3306" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 p-2 border" required>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Database Name</label>
                    <input type="text" name="db_database" placeholder="magicai" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 p-2 border" required>
                    <p class="text-xs text-gray-500 mt-1">Create this database in phpMyAdmin first.</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Username</label>
                    <input type="text" name="db_username" placeholder="root" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 p-2 border" required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Password</label>
                    <input type="password" name="db_password" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 p-2 border">
                </div>
            </div>
        </div>

        <!-- Admin Section -->
        <div>
            <h3 class="text-lg font-medium text-gray-900 border-b pb-2 mb-4 mt-6">Admin Account</h3>
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Full Name</label>
                    <input type="text" name="admin_name" placeholder="Admin User" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 p-2 border" required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Email Address</label>
                    <input type="email" name="admin_email" placeholder="admin@example.com" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 p-2 border" required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Password</label>
                    <input type="password" name="admin_password" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 p-2 border" required>
                </div>
            </div>
        </div>

        <div class="pt-4">
            <button type="submit" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors">
                Install Application
            </button>
            <p class="text-center text-xs text-gray-500 mt-4">
                This process may take a few seconds. Please don't close the window.
            </p>
        </div>
    </form>
@endsection
